/*****************************************************************************
 * Twitch Cross-Platform Client Application
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2016-2017 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "app/storagemanager.h"

namespace app {
namespace ps4 {
class PS4StorageManager;
}  // namespace ps4
}  // namespace app

class app::ps4::PS4StorageManager : public app::sce::StorageManager {
 protected:
  virtual int32_t ScePrepare(const SceSaveDataMountPoint& /*mountPoint*/) { return SCE_OK; };
  virtual int32_t SceCommit() { return SCE_OK; };
  virtual int32_t SceMount(const MountParams& params, SceSaveDataMountResult& result);
  virtual int32_t SceUnmount(const SceSaveDataMountPoint& mountPoint);
  virtual int32_t GetTransactionResourceId() { return 0; }
};
