#pragma once

#include <iostream>
#include <stdexcept>

constexpr unsigned int kLogLevel = 3;

namespace app {
namespace sce {
enum kLogLevels { LogLevel_Error = 0, LogLevel_Warning, LogLevel_Info, LogLevel_Debug };
}  // namespace sce
}  // namespace app

template <typename Tag, typename Message>
static inline void LogMessage(unsigned int level, Tag tag, Message m) {
  FILE* f = level == app::sce::LogLevel_Error ? stderr : stdout;
  if (level <= kLogLevel) {
    fprintf(f, "%s::%s\n", tag, m);
  }
}

#define APP_LOGE(tag, message) LogMessage(app::sce::LogLevel_Error, tag, message)
#define APP_LOGW(tag, message) LogMessage(app::sce::LogLevel_Warning, tag, message)
#define APP_LOGI(tag, message) LogMessage(app::sce::LogLevel_Info, tag, message)
#define APP_LOGD(tag, message) LogMessage(app::sce::LogLevel_Debug, tag, message)

#define APP_ASSERT(expr, tag, code) \
  {                                 \
    if (expr) {                     \
      APP_LOGE(tag, code);          \
      do {                          \
      } while (1);                  \
    }                               \
  }
