#pragma once

#include "app/utils.h"

#include <common_dialog.h>
#include <libsysmodule.h>
#include <web_browser_dialog.h>

#include <string>

namespace app {
namespace sce {
class WebBrowser;
enum kWebResponse { WebResponse_Stop = 0, WebResponse_Ok, WebResponse_Login, WebResponse_Logout };
}  // namespace sce
}  // namespace app

class app::sce::WebBrowser {
 public:
  WebBrowser() { sceSysmoduleLoadModule(SCE_SYSMODULE_WEB_BROWSER_DIALOG); };
  ~WebBrowser() { sceSysmoduleUnloadModule(SCE_SYSMODULE_WEB_BROWSER_DIALOG); };
  virtual int32_t Initialize(SceUserServiceUserId userID, const char *url);
  virtual int32_t Terminate();
  virtual int32_t Refresh();
  virtual app::sce::kWebResponse Update();

 private:
  SceWebBrowserDialogCallbackInitParam initCallbackParam;
  SceWebBrowserDialogCallbackResultParam callbackParam;
  SceWebBrowserDialogWebViewParam webViewParam;
  SceWebBrowserDialogParam browserParam;
  SceWebBrowserDialogResult resultParam;
};
