# Packaging the PS4 Application

## Configuring the Build

1. Run the `package/scripts/configure_build.py` script with desired options. At
   minimum you must specify the following:

```
python configure_build.py --region=siea --volume-type=remaster --twitch-build-number=12345 --commit-hash=ae34asdf23cv34 --sce-master-version=01.00 --sce-app-version=01.20 --sce-title-id=CUSA03285 --sce-content-id=UP8902-CUSA03285_00-TWITCHPS4APPSCEA
```

## Packaging the build

1. First build the ps4 app shell with Visual Studio. This will generate the
   `StarshotPS4.elf` and `StarshotPS4.map` files in `ORBIS_DEBUG` that are
   needed for packaging the build.
1. Configure the build (see above)
1. Run the `package/scripts/package.py` script with desired options. At minimum
   you must specify the following:

```
python package.py --build-config=Release --region=siea --volume-type=remaster --sce-app-version=01.20
```

## Debugging an installed package

1. You can install a .pkg file (located in `package/submissions`) using
   Playstation neighborhood `Packages and entitlements`
1. Run the package on the Playstation
1. While the package is running attach the Visual Studio debugger
   1. Select `PS4 Application Debugger` from the green run button dropdown
   1. Select `Debug->Attach To Process`
   1. Select `PlayStation4 Target` as Connection Type and select your process on
      the Playstation
