#!/usr/bin/python
#
# This script contains a helper function to read the versions.json file.
# Used by each platform's release.py and configure_build.py
#
#

import os
import json

def get_data(platform):
    tools_dir = os.path.realpath(os.path.dirname(__file__))
    meta_dir = os.path.realpath(os.path.join(tools_dir, '..', 'meta'))
    platform_data = None
    with open(os.path.join(meta_dir, 'versions.json'), 'r') as versions_file:
        data = json.load(versions_file)
        platform_data = data.get(platform)
        if not platform_data:
            raise Exception('Could not find data for platform "' + platform +'" in versions.json')
    return platform_data

def get_version(platform):
    # Get version number for platform from versions.json
    platform_data = get_data(platform)
    version = platform_data.get('twitch-version')
    if version is None:
        raise Exception('Could not find "twitch-version" for platform "' + platform + '" in versions.json')
    return version

# PS4 names

sieaRegionName = "siea"
sieasiaRegionName = "sieasia"
sieeRegionName = "siee"

sieaPatchName = "A0140.docx"
sieasiaPatchName = "A0131.docx"
sieePatchName = "A0136.docx"
