#include "app/ps4storagemanager.h"
#include "app/webbrowser.h"

#include <system_service.h>

namespace {
const char *kDebugURL = "https://87hn6uil7zv5hvmly5mz.tv.twitch.a2z.com";
//const char *kDebugURL = "https://osposbc8hid4yfli2i3e.tv.twitch.a2z.com/";
//const char *kDebugURL = "https://192.168.0.121:19000";
SceUserServiceUserId gUserID = SCE_USER_SERVICE_USER_ID_INVALID;
app::sce::WebBrowser gWebBrowser;
app::ps4::PS4StorageManager gStorageManager;
}  // namespace

int main(void) {
  int ret;
  ret = sceUserServiceInitialize(nullptr);
  ret = sceUserServiceGetInitialUser(&gUserID);

  gStorageManager.Initialize();
  gWebBrowser.Initialize(gUserID, kDebugURL);
  sceSystemServiceHideSplashScreen();

  app::sce::kWebResponse res = app::sce::WebResponse_Ok;
  while (res != app::sce::WebResponse_Stop) {
    switch (res = gWebBrowser.Update()) {
      case app::sce::WebResponse_Login:
        // TODO: <rjh> Add hooks to persist token data
        gWebBrowser.Refresh();
        break;
      case app::sce::WebResponse_Logout:
        // TODO: <rjh> Add hooks to delete token data
        gWebBrowser.Refresh();
        break;
      default:
        break;
    }
  }

  gWebBrowser.Terminate();
  gStorageManager.Terminate();

  return 0;
}
