/****************************************************************************
 * Twitch Cross-Platform Client Application
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2016-2017 Twitch Interactive, Inc.
 ***************************************************************************/

#include "app/playstationplatformuser.h"

#include <np.h>
#include <np/np_auth.h>
#include <np/np_error.h>
#include <user_service.h>

#define TVAPP_SIMULATE_PLATFORMUSER_INITIALIZE_FAILURE 0

// namespace {
// constexpr char kLogTag[] = "PlaystationPlatformUser";
// }  // namespace
//
// app::sce::PlaystationPlatformUser::~PlaystationPlatformUser() {
//   APP_LOGD(kLogTag, "PlaystationPlatformUser::~PlaystationPlatformUser");
// }
//
// app::AsyncResultPtr<void> app::sce::PlaystationPlatformUser::Initialize() {
//   APP_LOGD(kLogTag, "PlaystationPlatformUser::Initialize()");
//
//   auto context = GetContext();
//
//   if (context->arInitialize != nullptr && !context->arInitialize->IsRejected()) {
//     return context->arInitialize;
//   }
//
//   context->arInitialize = PlatformUser::Initialize();
//
// // Simulate failure
// #if TVAPP_SIMULATE_PLATFORMUSER_INITIALIZE_FAILURE
//   static int numFailures = 10;
//   if (numFailures > 0) {
//     numFailures--;
//
//     context->arInitialize = context->arInitialize->Then<void>(AR_LOC, []() {
//       ASYNC_RESULT_THROW(std::make_shared<UserCancelError>("PlaystationPlatformUser::Initialize()-TestFailure"));
//     });
//   }
// #endif
//
//   // Kick off update of chat restrictions that doesn't block startup
//   UpdateChatRestrictions();
//
//   return context->arInitialize;
// }
//
// std::string app::sce::PlaystationPlatformUser::GetDisplayName() const {
//   // TODO: Do we care about your PSN display name?
//   return "PLAYSTATION TODO";
// }
//
// app::AsyncResultPtr<app::PlatformUser::ChatRestrictions> app::sce::PlaystationPlatformUser::UpdateChatRestrictions() {
//   return CheckUserRestrictions()->Then<ChatRestrictions>(
//     AR_LOC, [baseContext = PlatformUser::mContext](
//               const PlaystationUserRestrictions& /*result*/) { return baseContext->chatRestrictions; });
// }
//
// app::AsyncResultPtr<app::sce::PlaystationUserRestrictions> app::sce::PlaystationPlatformUser::CheckUserRestrictions() {
//   APP_LOGD(kLogTag, "PlaystationPlatformUser::CheckUserRestrictions");
//
//   auto context = GetContext();
//
//   if (context->arUserRestrictions != nullptr && !context->arUserRestrictions->IsRejected()) {
//     return context->arUserRestrictions;
//   }
//
//   auto queue = GetAsyncResultQueue();
//   auto baseContext = PlatformUser::mContext;
//
//   context->arUserRestrictions = GetAsyncResultTracker()->CreateAsyncResult<PlaystationUserRestrictions>(AR_LOC);
//
//   auto arAvailability = CheckPsnAvailability();
//   auto arParentalControls = CheckParentalControls();
//
//   auto all = GetAsyncResultTracker()->CreateAllAsyncResult(AR_LOC);
//   all->AddDependency(arAvailability);
//   all->AddDependency(arParentalControls);
//
//   all
//     ->Then<void>(AR_LOC,
//       [baseContext, ar = context->arUserRestrictions, arAvailability, arParentalControls]() {
//         auto userRestrictions = arParentalControls->GetResult();
//         userRestrictions.psnUnavailable = !arAvailability->GetResult();
//
//         baseContext->chatRestrictions.viewingAllowed = !userRestrictions.chatRestriction;
//         baseContext->chatRestrictions.sendingAllowed = !userRestrictions.chatRestriction;
//
//         ar->Resolve(userRestrictions);
//       })
//     ->Catch(AR_LOC, [ar = context->arUserRestrictions, all](const ErrorPtr& error) {
//       ar->Reject(
//         std::make_shared<GenericError>("PlaystationPlatformUser::CheckUserRestrictions-AllAsyncFailed", error));
//     });
//
//   all->Start();
//
//   return context->arUserRestrictions;
// }
//
// app::AsyncResultPtr<void> app::sce::PlaystationPlatformUser::ShowSystemMessageDialog(
//   SceMsgDialogSystemMessageType msgType) {
//   APP_LOGD(kLogTag, "PlaystationPlatformUser::ShowSystemMessageDialog");
//
//   auto context = GetContext();
//
//   sceMsgDialogInitialize();
//
//   SceMsgDialogParam param;
//   sceMsgDialogParamInitialize(&param);
//   param.mode = SCE_MSG_DIALOG_MODE_SYSTEM_MSG;
//
//   SceMsgDialogSystemMessageParam sysMsgParam;
//   memset(&sysMsgParam, 0, sizeof(sysMsgParam));
//   sysMsgParam.sysMsgType = msgType;
//   param.sysMsgParam = &sysMsgParam;
//   param.userId = context->localUserId;
//
//   int32_t ret = sceMsgDialogOpen(&param);
//
//   auto arRequest = GetAsyncResultTracker()->CreateAsyncResult<int>(AR_LOC);
//
//   if (ret >= SCE_OK) {
//     // Wait for the request to complete asynchronously
//     context->apiPoller->WaitForSystemDialog(arRequest);
//   } else {
//     arRequest->Reject(std::make_shared<PlaystationApiError>(
//       "PlaystationPlatformUser::ChatOrUGCRestrictionDialog-FailedToOpenDialog", ret));
//   }
//
//   // Absorb any result, just dismiss the dialog
//   return arRequest->Then<void>(AR_LOC, [](int /*result*/) {})->Catch(AR_LOC, [](const ErrorPtr& /*error*/) {});
// }
