#include "app/ps4.h"

app::ps4::PlayStation4::PlayStation4() {
  int ret = 0;
  ret = sceSysmoduleLoadModule(SCE_SYSMODULE_WEB_BROWSER_DIALOG);
}

app::ps4::PlayStation4::~PlayStation4() {
  int ret = 0;
  ret = sceSysmoduleUnloadModule(SCE_SYSMODULE_WEB_BROWSER_DIALOG);
}

void app::ps4::PlayStation4::Initialize() {
  int ret = 0;
  ret = sceUserServiceInitialize(nullptr);
  ret = sceCommonDialogInitialize();
  ret = sceWebBrowserDialogInitialize();

  InitUserIDParam();
  InitCallbackParam();
  InitResultParam();
  InitWebViewParam();

  sceWebBrowserDialogParamInitialize(&browserParam);
  InitBrowserParam();

  ret = sceWebBrowserDialogOpen(&browserParam);
}

void app::ps4::PlayStation4::Terminate() {
  int ret = 0;
  ret = sceWebBrowserDialogGetResult(&resultParam);
  ret = sceWebBrowserDialogTerminate();
}

void app::ps4::PlayStation4::InitUserIDParam() {
  int ret = 0;
  userId = SCE_USER_SERVICE_USER_ID_INVALID;
  ret = sceUserServiceGetInitialUser(&userId);
}

void app::ps4::PlayStation4::InitCallbackParam() {
  memset(&callbackParam, 0, sizeof(callbackParam));
  callbackParam.size = sizeof(SceWebBrowserDialogCallbackResultParam);
}

void app::ps4::PlayStation4::InitResultParam() {
  memset(&resultParam, 0x00, sizeof(resultParam));
  resultParam.callbackResultParam = &callbackParam;
}

void app::ps4::PlayStation4::InitWebViewParam() {
  memset(&webViewParam, 0, sizeof(webViewParam));
  webViewParam.size = sizeof(webViewParam);
  webViewParam.option = SCE_WEB_BROWSER_DIALOG_WEBVIEW_OPTION_CURSOR_NONE;
}

bool app::ps4::PlayStation4::Update() {
  SceCommonDialogStatus status = sceWebBrowserDialogUpdateStatus();

  if (status == SCE_COMMON_DIALOG_STATUS_FINISHED) {
    return false;
  } else if (status == SCE_COMMON_DIALOG_STATUS_RUNNING) {
    if (false) {
      sceWebBrowserDialogClose();
      return false;
    }
  }

  return true;
}

void app::ps4::PlayStation4::InitBrowserParam() {
  browserParam.mode = SCE_WEB_BROWSER_DIALOG_MODE_CUSTOM;
  browserParam.userId = userId;
  // To-Do <rjh>: This should be set via a parameter (and more importantly through a list of URLs loaded)
  //  by the file system. Once it is loaded, it should be checked (i.e. get a 200 response) through some http manager
  browserParam.url = "https://osposbc8hid4yfli2i3e.tv.twitch.a2z.com/";
  browserParam.callbackInitParam = nullptr;
  browserParam.width = 1920;
  browserParam.height = 1080;
  browserParam.positionX = 0;
  browserParam.positionY = 0;
  browserParam.parts = SCE_WEB_BROWSER_DIALOG_CUSTOM_PARTS_NONE;
  browserParam.headerWidth = 1920;
  browserParam.headerPositionX = 0;
  browserParam.headerPositionY = 0;
  browserParam.control = SCE_WEB_BROWSER_DIALOG_CUSTOM_CONTROL_BACK;
  browserParam.imeParam = nullptr;
  browserParam.webviewParam = &webViewParam;
  browserParam.animation = SCE_WEB_BROWSER_DIALOG_ANIMATION_DISABLE;
}
