/****************************************************************************
 * Twitch Cross-Platform Client Application
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2016-2017 Twitch Interactive, Inc.
 ***************************************************************************/

#include "app/ps4platformuser.h"

#include <np.h>

// namespace {
// constexpr char kLogTag[] = "Ps4PlatformUser";
// }  // namespace
//
// app::ps4::Ps4PlatformUser::Ps4PlatformUser(SceUserServiceUserId userId) : PlaystationPlatformUser() {
//   mContext = CreateContext();
//
//   auto context = GetContext();
//   context->localUserId = userId;
// }
//
// app::AsyncResultPtr<void> app::ps4::Ps4PlatformUser::ShowUserGeneratedContentMessage() {
//   return ShowSystemMessageDialog(SCE_MSG_DIALOG_SYSMSG_TYPE_TRC_PSN_UGC_RESTRICTION);
// }
//
// app::AsyncResultPtr<void> app::ps4::Ps4PlatformUser::ShowChatRestrictionMessage() {
//   return ShowSystemMessageDialog(SCE_MSG_DIALOG_SYSMSG_TYPE_TRC_PSN_CHAT_RESTRICTION);
// }
//
// app::AsyncResultPtr<bool> app::ps4::Ps4PlatformUser::CheckPsnAvailability() {
//   APP_LOGD(kLogTag, "Ps4PlatformUser::CheckPsnAvailability");
//
//   auto context = GetContext();
//
//   SceNpCreateAsyncRequestParameter params;
//   memset(&params, 0, sizeof(params));
//   params.size = sizeof(params);
//
//   auto arRequest = GetAsyncResultTracker()->CreateAsyncResult<int>(AR_LOC);
//
//   int requestId = sceNpCreateAsyncRequest(&params);
//   if (requestId > 0) {
//     int ret = sceNpCheckNpAvailabilityA(requestId, context->localUserId);
//     if (ret == SCE_OK) {
//       // Wait for the request to complete asynchronously
//       context->apiPoller->WaitForNpRequest(arRequest, requestId);
//     } else {
//       arRequest->Reject(std::make_shared<sce::PlaystationApiError>(
//         "Ps4PlatformUser::CheckPsnAvailability-sceNpCheckNpAvailabilityA Failed", ret));
//     }
//   } else {
//     arRequest->Reject(std::make_shared<sce::PlaystationApiError>(
//       "Ps4PlatformUser::CheckPsnAvailability-RequestCreationFailed", requestId));
//   }
//
//   return arRequest->Then<bool>(AR_LOC, [](int requestResult) { return requestResult >= SCE_OK; })
//     ->Finally(AR_LOC, [requestId]() {
//       if (requestId > 0) {
//         int ret = sceNpDeleteRequest(requestId);
//         APP_ASSERT(ret == SCE_OK, kLogTag, "Ps4PlatformUser::CheckPsnAvailability-sceNpDeleteRequest failed 0x",
//           logarg::ToHexString(ret));
//       }
//     });
// }
//
// app::AsyncResultPtr<app::sce::PlaystationUserRestrictions> app::ps4::Ps4PlatformUser::CheckParentalControls() {
//   APP_LOGD(kLogTag, "Ps4PlatformUser::CheckParentalControls");
//
//   auto context = GetContext();
//
//   SceNpCreateAsyncRequestParameter params;
//   memset(&params, 0, sizeof(params));
//   params.size = sizeof(params);
//
//   struct Data {
//     Data() : age(0) { memset(&info, 0, sizeof(info)); }
//
//     SceNpParentalControlInfo info;
//     int8_t age;
//   };
//
//   auto data = std::make_shared<Data>();
//   auto arRequest = GetAsyncResultTracker()->CreateAsyncResult<int>(AR_LOC);
//
//   int requestId = sceNpCreateAsyncRequest(&params);
//   if (requestId > 0) {
//     int ret = sceNpGetParentalControlInfoA(requestId, context->localUserId, &data->age, &data->info);
//     if (ret >= SCE_OK) {
//       context->apiPoller->WaitForNpRequest(arRequest, requestId);
//     } else {
//       arRequest->Reject(std::make_shared<sce::PlaystationApiError>(
//         "Ps4PlatformUser::CheckParentalControls-sceNpCheckNpAvailabilityA Failed", ret));
//     }
//   } else {
//     arRequest->Reject(std::make_shared<sce::PlaystationApiError>(
//       "Ps4PlatformUser::CheckParentalControls-RequestCreationFailed", requestId));
//   }
//
//   return arRequest
//     ->Then<sce::PlaystationUserRestrictions>(AR_LOC,
//       [data](int requestResult) {
//         sce::PlaystationUserRestrictions restrictions;
//
//         if (false) {
//           //restrictions.ugcRestriction = true;
//           //restrictions.chatRestriction = true;
//           //restrictions.appPatchExists = true;
//           //restrictions.systemSoftwareUpdateExists = true;
//           //restrictions.contentRestriction = true;
//         } else if (requestResult < SCE_OK) {
//           switch (requestResult) {
//             case SCE_NP_ERROR_LATEST_PATCH_PKG_EXIST:
//             case SCE_NP_ERROR_LATEST_PATCH_PKG_DOWNLOADED: {
//               restrictions.appPatchExists = true;
//               break;
//             }
//             case SCE_NP_ERROR_LATEST_SYSTEM_SOFTWARE_EXIST:
//             case SCE_NP_ERROR_LATEST_SYSTEM_SOFTWARE_EXIST_FOR_TITLE: {
//               restrictions.systemSoftwareUpdateExists = true;
//               break;
//             }
//             case SCE_NP_ERROR_AGE_RESTRICTION: {
//               restrictions.contentRestriction = true;
//               break;
//             }
//             case SCE_NP_ERROR_SIGNED_OUT: {
//               restrictions.signedOut = true;
//               break;
//             }
//             default: {
//               throw std::static_pointer_cast<Error>(std::make_shared<sce::PlaystationApiError>(
//                 "Ps4PlatformUser::CheckParentalControls-ParentalControlRequestFailed", requestResult));
//             }
//           }
//         } else {
//           if (data->info.ugcRestriction) {
//             restrictions.ugcRestriction = true;
//           }
//
//           if (data->info.chatRestriction) {
//             restrictions.chatRestriction = true;
//           }
//         }
//
//         return restrictions;
//       })
//     ->Finally(AR_LOC, [requestId]() {
//       if (requestId > 0) {
//         sceNpDeleteRequest(requestId);
//       }
//     });
// }
