/****************************************************************************
 * Twitch Cross-Platform Client Application
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2016-2020 Twitch Interactive, Inc.
 ***************************************************************************/

#include "app/ps4storagemanager.h"

namespace {
constexpr const char* kLogTag = "PS4StorageManager";
}

int32_t app::ps4::PS4StorageManager::SceMount(const MountParams& params, SceSaveDataMountResult& result) {
  memset(&result, 0, sizeof(result));

  SceSaveDataDirName dirName;
  APP_ASSERT(params.containerName.size() < sizeof(dirName.data) - 1, kLogTag, "Container name too long");
  snprintf(dirName.data, sizeof(dirName.data), "%s", params.containerName.c_str());

  auto config = SceSaveDataMount2();
  memset(&config, 0, sizeof(config));
  config.userId = params.userId;
  config.dirName = &dirName;
  config.mountMode = params.mountMode;
  config.blocks = params.numBlocks;
  return sceSaveDataMount2(&config, &result);
}

int32_t app::ps4::PS4StorageManager::SceUnmount(const SceSaveDataMountPoint& mountPoint) {
  return sceSaveDataUmount(&mountPoint);
}
