#include <app/webbrowser.h>

int32_t app::sce::WebBrowser::Initialize(SceUserServiceUserId userID, const char *url) {
  int ret;
  ret = sceCommonDialogInitialize();
  ret = sceWebBrowserDialogInitialize();
  sceWebBrowserDialogParamInitialize(&browserParam);

  browserParam.userId = userID;
  browserParam.url = url;

  browserParam.mode = SCE_WEB_BROWSER_DIALOG_MODE_CUSTOM;
  browserParam.width = 1920;
  browserParam.height = 1080;
  browserParam.positionX = 0;
  browserParam.positionY = 0;
  browserParam.parts = SCE_WEB_BROWSER_DIALOG_CUSTOM_PARTS_NONE;
  browserParam.headerWidth = 1920;
  browserParam.headerPositionX = 0;
  browserParam.headerPositionY = 0;
  browserParam.control = SCE_WEB_BROWSER_DIALOG_CUSTOM_CONTROL_BACK;
  browserParam.imeParam = nullptr;
  browserParam.webviewParam = &webViewParam;
  browserParam.animation = SCE_WEB_BROWSER_DIALOG_ANIMATION_DISABLE;

  memset(&initCallbackParam, 0, sizeof(initCallbackParam));
  initCallbackParam.size = sizeof(SceWebBrowserDialogCallbackInitParam);
  initCallbackParam.type = SCE_WEB_BROWSER_DIALOG_CALLBACK_PARAM_TYPE_REGEXP;
  initCallbackParam.data = "tv.twitch.tv/_ipc?";
  browserParam.callbackInitParam = &initCallbackParam;

  memset(&callbackParam, 0, sizeof(callbackParam));
  callbackParam.size = sizeof(SceWebBrowserDialogCallbackResultParam);

  memset(&resultParam, 0x00, sizeof(resultParam));
  resultParam.callbackResultParam = &callbackParam;

  memset(&webViewParam, 0, sizeof(webViewParam));
  webViewParam.size = sizeof(webViewParam);
  webViewParam.option = SCE_WEB_BROWSER_DIALOG_WEBVIEW_OPTION_CURSOR_NONE;

  ret = sceWebBrowserDialogOpen(&browserParam);
  return ret;
}

int32_t app::sce::WebBrowser::Terminate() {
  sceWebBrowserDialogGetResult(&resultParam);
  sceWebBrowserDialogTerminate();
  return 0;
}

int32_t app::sce::WebBrowser::Refresh() {
  sceWebBrowserDialogClose();
  sceWebBrowserDialogOpen(&browserParam);
  return 0;
}

app::sce::kWebResponse app::sce::WebBrowser::Update() {
  SceCommonDialogStatus status = sceWebBrowserDialogUpdateStatus();
  app::sce::kWebResponse res = app::sce::WebResponse_Ok;
  if (status == SCE_COMMON_DIALOG_STATUS_FINISHED) {
    memset(&resultParam, 0x00, sizeof(resultParam));
    resultParam.callbackResultParam = &callbackParam;
    sceWebBrowserDialogGetResult(&resultParam);

    char *callBackURL = resultParam.callbackResultParam->data;

    if (strstr(callBackURL, "login")) {
      res = app::sce::WebResponse_Login;
    } else if (strstr(callBackURL, "logout")) {
      res = app::sce::WebResponse_Logout;
    } else {
      res = app::sce::WebResponse_Stop;
    }
  } else if (status == SCE_COMMON_DIALOG_STATUS_RUNNING) {
    res = app::sce::WebResponse_Ok;
  }

  return res;
}
