# Raspberry PI DNS Server

If you want to test video playback against your locally hosted web app on
another device where you don't have access to the hosts file you need to set up
a DNS server on your network. The DNS server will redirect traffic intended for
Twitch to your locally hosted app on your laptop which bypasses issues with CORS
in the browser.

Take note that your laptop won't be visible to devices trying to connect to it
if you are on the Amazon VPN.

## Raspberry PI Setup

This image should be made available somewhere but in case you need to set it up
from scratch here are the steps. Even if you use the image you will still need
to configure a static IP address for the device.

The goal of these steps is to avoid having to plug in a temporary keyboard,
mouse and monitor for setup. This might not be possible if you don't know the
MAC address of the ethernet dongle.

### Recommended Hardware

- [Raspberry PI Zero](https://www.raspberrypi.org/products/raspberry-pi-zero/)
- Ethernet USB dongle
- Ethernet cable connected to switch/router
- 8 GB or larger SD card

### OS Installation (One-time setup)

- Mount the SD card on a laptop.
- Install Raspberry PI OS Lite on the SD card using the
  [Raspberry PI Imager tool](https://www.raspberrypi.org/software/).
- Add an empty file called `ssh` to the root of the SD card.
- Unmount the SD card and insert it into the Pi Zero.
- Plug in the ethernet USB dongle to the USB port.
- Plug a power supply into the PWR port.
- Wait a minute for it to boot up.

### Static IP Configuration (One-time setup)

- Configure a static IP for the PI.
  - Use static DHCP on your router, if possible, since it's controlled all in
    one place and reimaging a device doesn't wipe the configuration.
    - You need the mac address of the ethernet dongle on the PI. If you plug it
      into your network then this should be found in the DHCP table on your
      router. Otherwise, you might need to plug in a keyboard and monitor so you
      can type in `ifconfig`.
  - Alternatively, configure the static IP on your PI directly. You'll need a
    keyboard and monitor hooked up to do this.
    - Google it!
- SSH into the Pi using the assigned IP address.
  - `ssh pi@<pi_ip_address>`
  - Default password is `raspberry`.
- Change the default password if you want.
  - `passwd`

#### DNS Server Setup (One-time)

- SSH into the PI using the assigned IP address.
  - `ssh pi@<pi_ip_address>`
- Install the DNS server `dnsmasq`

  ```
  sudo apt update
  sudo apt upgrade
  sudo apt install dnsmasq
  ```

- Configure the DNS server `sudo nano /etc/dnsmasq.conf`.

  - Add
    - `server=8.8.8.8`
    - `server=8.8.4.4`
  - Remove
    - `server=/localnet/192.168.0.1`
  - Replace
    - `#domain-needed` -> `domain-needed`
    - `#bogus-priv` -> `bogus-priv`
    - `#no-resolv` -> `no-resolv`
    - `#cache-size=150` -> `cache-size=1000`
    - `#log-queries` -> `log-queries`

- Enable the service

```
sudo systemctl start dnsmasq
sudo systemctl enable dnsmasq
```

### Adding DNS Server Host->IP Mappings on Raspberry PI

If you assign your macbook a static IP in a similar way you assigned an IP to
the Pi then you only need to do this one. If not, you may have to update the
hosts file on the Pi when it changes.

- SSH into the PI using the assigned IP address.
  - `ssh pi@<pi_ip_address>`
- Edit `/etc/hosts`
- Add
  `<dev_machine_ip> localhost.m.twitch.tv localhost.tv.twitch.tv localhost.valence.tv.twitch.tv`
- You may need to restart the DNS service, I'm not sure.
  - `sudo systemctl restart dnsmasq`

### Device-Specific Internet Connection Setup (One-time setup per device)

Each device will have its own way of configuring a custom DNS server. In many
cases, when setting a DNS server on a device a reboot is required for the
changes to be reflected. Don't forget to reboot as it can be very frustrating
because it's not apparent that it's not trying to use your DNS server.

If you boot up a device and the DNS server is not available most devices will
direct DNS requests to fallback DNS servers. You will probably have to reboot
the device when your DNS server is back up for it to be found and used.

### Allowing External Connections on Amazon MacBook Pro (One-time setup)

- Edit `/usr/local/amazon/var/quarantine/ipv6/template-com.amazon.custom` if you
  already have one or copy a template config file if not

```
sudo mv /usr/local/amazon/var/quarantine/template-com.amazon.custom /usr/local/amazon/var/quarantine/ipv6/template-com.amazon.custom

```

- Add this to the config file:

```
## FILTER
pass in inet proto {tcp} from any to any port 19000 keep state
```

- Disconnect and reconnect to wifi/ethernet to apply the changes.

- Update Laser Array or app shell URL to use port 19000 when connecting to
  Starshot.
- The yarn command for `starshot-proxy` should already have port 19000 set to
  point to port 443 in the container.
