# WebOS

Platform: LG

## Support Matrix

The oldest model year we support for LG TVs is 2017. Helpful resources:

- [Web Engine by Release Year](http://webostv.developer.lge.com/discover/specifications/web-engine/)
- [LG Media Support Matrix by Web Engine](http://webostv.developer.lge.com/discover/specifications/supported-media-formats/)
- [WASM Support](https://caniuse.com/#search=WASm)

## Application Architecture:

We ship [Laser Array](../laser-array/README.md), a minimal launcher that
redirects to the main Starshot application if it's healthy. WebOS refers to this
as a
[hosted web app](http://webostv.developer.lge.com/develop/app-developer-guide/hosted-web-app/)

## Setup

### Installing the CLI Tools

LG provides a handful of [tools](http://webostv.developer.lge.com/sdk/tools/)
that can be used for development. The useful ones include the Emulator and CLI
tool.

You can download the
[full package installer](http://webostv.developer.lge.com/sdk/installation/) and
follow the instructions to install all of the necessary tools.

Note: ZSH users will manually need to add the following to their `.zshrc` file:

```
export WEBOS_CLI_TV=/opt/webOS_TV_SDK/CLI/bin
export LG_WEBOS_TV_SDK_HOME=/opt/webOS_TV_SDK
```

http://webostv.developer.lge.com/sdk/tools/using-webos-tv-cli/?wos_flag=ares-install

Consider adding `$WEBOS_CLI_TV` to your `PATH` after installing the CLI tools.
Otherwise, the provided scripts do this for you.

### New TV Setup

1. [Enable developer mode](http://webostv.developer.lge.com/develop/app-test/#turningDeveloperModeOn)
   on the TV.

### Connecting Your Computer To A TV For The First Time

This step only needs to be done once for each new TV you connect to. Once it is
set up, you can skip directly to installation/running.

1. Ensure you are on the same Wi-Fi network ("Guest" at Twitch offices) as the
   TV and are off VPN.
2. Run `yarn tv:setup` and follow the instructions to connect to the TV for the
   first time:
   1. Enter a name for the TV.
   2. Use the "Device IP address" listed in the TV's Developer app and default
      values for the rest of the prompts.
   3. **Note:** You do **NOT** need to enter a password on initial setup. But
      you **WILL** need to enter it from the TV when generating the key file
   4. For additional context, see the
      [Connecting TV and PC](http://webostv.developer.lge.com/develop/app-test)
      instructions

### Launching The Native App

1. Ensure you are on the same Wi-Fi network ("Guest" at Twitch offices) as the
   TV and are off VPN.
2. Build the IPK unless you already have one to test against: `yarn build`.
3. Run `yarn start`. This will install and launch the app onto the specified
   device.

## Testing

### Local Computer

1. Build the app as usual using `yarn build`
2. Run `yarn serve`
3. Open `localhost:5000` in either Chromium 38 (simulate 2017 TV) or Chromium 53
   (simulate 2019 TV). Downloads for both are
   [here](https://drive.google.com/drive/u/0/folders/1wT07VF1pASeKdMPpkMejCEgZPW9UfZn6).

NOTE: When deployed to a TV, assets are served from the file system. This
differs from `yarn serve` which is serving assets from a web server. Any file
additions or path changes in [Laser Array](../laser-array/README.md) should be
verified on a TV. In particular, root relative (`/my-img.png`) and protocol
relative (`//assets.cdn.com`) will fail on the TV but succeed when running
`yarn serve`.

### TV

http://webostv.developer.lge.com/develop/app-test/

Twitch Office Note:

The ares cli communicates to the TV over LAN. Both the TV and your laptop must
be on the same network. At Twitch offices, only the 'Guest' network allows
devices to discover one another. Connect both the target TV and your laptop to
the 'Guest' network before using any of the below `yarn` commands.

### Testing Starshot Unavailable

Choose the 'Local' URL option when building. The URL request to Starshot's
health check will fail on the TV, which will cause the 500 page to show.

### Debugging with the Web Inspector

The `ares-inspector` provides a web inspector for debugging purposes. Run
`yarn tv:inspector` while the app is running on a device to launch it.

## Common Build Errors

`ares-install ERR! ares-install: Error: Connection time out. please check the device IP address or port.`

Assuming you have already
[setup](#connecting-your-computer-to-a-tv-for-the-first-time) the TV:

1. Ensure that the "IP Address" in the LG Dev App on the TV matches the
   corresponding `yarn tv:setup` entry, otherwise update.
2. Ensure that you are not on VPN.

`ares-install ERR! ares-install: Error: All configured authentication methods failed`

Open the Developer app on the TV and ensure the Key Server is running.
