# LG QA Submission

## Prerequisites

1. Setup a Twitch
   [1Password](https://wiki.twitch.com/display/HD/How+to+set+up+your+Twitch+1Password+Account)
   account.

## The LG QA Submission Process

1. [Prepare the QA environment](./../../internal-docs/apps/starshot/qa-through-prod/)

1. Reset the `lg_qa` Git branch to the desired commit, push to origin, and
   [deploy to the LG QA environment](./../../internal-docs/starshot/deploying-starshot/)

1. [Build IPKs for 1080p and 720p](#building-ipks)

1. Validate the 1080p IPK on both a 2017 and 2019 TV and run through the
   Homepage to Video Playback flow.

1. Upload the new IPK to
   [google drive.](https://drive.google.com/drive/folders/1d42X7XWVW6RX0XzXMheOm8Uo5VlPgKJR)

1. Be sure that the self eval checklist and LG UX Scenarios are updated in
   [google drive.](https://drive.google.com/drive/folders/1d42X7XWVW6RX0XzXMheOm8Uo5VlPgKJR)

1. [Validate that the new IPK works on a physical TV.](#testing-an-ipk)

1. [Sign into the LG Seller Lounge with 1password.](http://seller.lgappstv.com/seller/main/Main.lge)

1. Edit the Twitch APP

1. Delete the old IPK and upload the new one

1. replace the old self eval checklist and LG UX scenarios with the new ones

1. A lot of the fields will populate based on the new IPK or will be prefilled
   from the previous submission.

1. Click `Submit` when ready and request QA when prompted.

## Building IPKs

New releases should increment the app version. This is done by updating the
version field in [appInfo.json](./src/appInfo.json)

Note that while Twitch Purple is supposed to be `#9147FF` when expressed in RGB,
due to differing HSL conversion algorithms the accompanying
`TWITCH_APP_ICON.png` has a background that is `#9146FF`, and so we must ensure
the `iconColor` value in `appInfo.json` is set to `#9146FF` to avoid failing QA.

The build process builds [Laser Array](../laser-array/README.md), supplying both
`REACT_APP_GIT_COMMIT` and `REACT_APP_STARSHOT_URL`.

1. Open a command prompt and navigate to `cd native-apps/webos/`
1. Run `yarn build`
1. You will be prompted for a Starshot app URL. The selected value will be
   supplied as the `STARSHOT_URL` environment variable for Laser Array.
1. The generated IPK will be in the `dist` directory.
1. Verify the IPK with `yarn analyze`. This will output important information
   about the IPK like the `STARSHOT_URL`. Make sure the output aligns with
   expected values for the release.

Final IPKs are uploaded to the
[Google Drive Folder](https://drive.google.com/drive/u/0/folders/1JLhZOjvOPjp7S6lRgwqIIb20v78R38sT).
It is located at Emerging Platforms Engineering Docs > Starshot Initiative >
LG > IPKs.

## Testing an IPK

http://webostv.developer.lge.com/sdk/tools/using-webos-tv-cli/testing-web-app-cli/

1. Run `yarn clean` to remove any local IPKs in the `dist` folder
2. `cp` your IPK to the `dist` folder:
   `cp ~/Downloads/tv.twitch.tv.starshot.lg_0.0.1_all.ipk dist/`
3. `yarn launch`

## App Descriptions

Presently, app descriptions are manually submitted. The description values are
copy and pasted into LG's submission form:

1. Login to [LG's Site](http://seller.lgappstv.com/seller/main/Main.lge).
1. The login credentials are stored in
   [1Password](https://wiki.twitch.com/display/HD/How+to+set+up+your+Twitch+1Password+Account),
   under the 'Starshot' vault.
1. Click 'App Management' in the top nav.
1. Click 'Edit' next to the Twitch App.
1. Click the 'Service Info.' tab in the top nav.

To make this process less painful, there is a helper script that generates
`lg-app-descriptions.txt` file with all of the app descriptions ordered and
named the same as the LG submission form. This file is automatically generated
when downloading translations via`yarn intl:download`. Each language is
delimitted with '=== $LANGUAGE ===', where $LANGUAGE corresponds to a language
name in the LG form. For now, these blocks can serve as the content that is
copied into the corresponding language blocks in the LG submission form.

We haven't figured out how to submit app descriptions via IPK uploads yet. In
theory, it should work like this:

The store description can be localized using a specific
[directory structure](http://webostv.developer.lge.com/develop/app-developer-guide/app-metadata/).
This structure is automatically built when downloading new translations, and the
resulting files should be committed to git.

The script that builds this structure is `scripts/localize-metadata.js`, and the
`formatMessage` call for translation is located in `appDescription.txt`.
