/**
 * This script builds a file for submitting LG App descriptions
 * http://seller.lgappstv.com/seller/appmgmt/appsubmission/AppModification.lge
 */
import { readFileSync, writeFileSync } from 'fs';
import { join } from 'path'

const MESSAGE_DIR = join(__dirname, '../messages');
const MESSAGE_FILE = 'messages.json';
const OUT = join(__dirname, '../lg-app-descriptions.txt');

/*
 * In order of display on LG form submission.
 *
 * Array of Tuples, where tuple is of the form:
 * [ LG name, translation folder ]
 */
const languages = [
  ["English", "en-gb"],
  ["Bulgarian", "bg"],
  ["Chinese", "zh-tw"],
  ["Czech", "cs"],
  ["Danish", "da"],
  ["Dutch", "nl"],
  ["Finnish", "fi"],
  ["French", "fr"],
  ["German", "de"],
  ["Greek", "el"],
  ["Hungarian", "hu"],
  ["Italian", "it"],
  ["Japanese", "ja"],
  ["Korean", "ko"],
  ["Polish", "pl"],
  ["Portuguese (Brazil)", "pt-br"],
  ["Portuguese", "pt"],
  ["Romanian", "ro"],
  ["Russian", "ru"],
  ["Chinese (Simplified)", "zh-cn"],
  ["Slovak", "cs"],
  ["Spanish (Latin American)", "es-mx"],
  ["Spanish (Spain)", "es"],
  ["Swedish", "sv"],
  ["Thai", "th"],
  ["Turkish", "tr"],
  ["Vietnamese", "vi"],
];

const descriptions = languages.map(([ name, folder]) => {
  const translationFile = join(MESSAGE_DIR, folder, MESSAGE_FILE);
  const translation = JSON.parse(readFileSync(translationFile).toString());
  const key = Object.keys(translation).find((k) => k.match(/LongFormDescription/))

  if (!key) {
    throw new Error("Could not find LongFormDescription key")
  }
  const description = translation[key];

  return [ name, description ]
})

writeFileSync(OUT,
 `THIS IS AN AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.
Regenerate this file by running 'yarn build-app-descriptions'.

=== LG App Descriptions ===

${descriptions.map(([ name, description ]) =>
`=== ${name} ===

${description}`
).join('\n\n')}
`)

console.log("Wrote ", OUT)
