import type { FC } from 'react';
import styled from 'styled-components';
import { useStaticEnvironment } from 'tachyon-environment';
import { Section } from './Section';

const ScClientBrowserAndOSExample = styled.div`
  background: papayawhip;
  color: maroon;
  display: flex;
`;

export const ClientBrowserAndOSExample: FC = () => {
  const { client } = useStaticEnvironment();

  if (!client) {
    return null;
  }

  const stringifiedInfo = Object.entries(client.agentInfo.getResult()).reduce<
    Record<string, string>
  >((val, [key, value]) => {
    val[key] = JSON.stringify(value);

    return val;
  }, {});

  return (
    <ScClientBrowserAndOSExample>
      <Section section={stringifiedInfo} title="Client User Agent Info" />
    </ScClientBrowserAndOSExample>
  );
};
