import type { FC } from 'react';
import styled from 'styled-components';
import { useStaticEnvironment } from 'tachyon-environment';
import { Section } from './Section';

const ScEnvironmentExample = styled.div`
  display: flex;
`;

export const EnvironmentExample: FC = () => {
  const { client, common } = useStaticEnvironment();

  return (
    <ScEnvironmentExample>
      <Section section={client} title="Client Environment" />
      <Section section={common} title="Common Environment" />
    </ScEnvironmentExample>
  );
};
