import type { FC } from 'react';
import styled from 'styled-components';

interface SectionProps {
  section: { [key: string]: any } | null;
  title: string;
}

const ScSection = styled.div`
  padding: 5rem;
`;

const ScKey = styled.p`
  font-weight: bold;
`;

export const Section: FC<SectionProps> = ({
  section,
  title,
}): JSX.Element | null => {
  if (!section) {
    return null;
  }

  return (
    <ScSection>
      <h1>{title}</h1>
      <dl>
        {Object.entries(section).map(([key, value], index) => (
          <div key={index}>
            <dt>
              <ScKey>{key}</ScKey>
            </dt>
            <dd>
              {typeof value !== 'undefined' ? value.toString() : 'Undefined'}
            </dd>
          </div>
        ))}
      </dl>
    </ScSection>
  );
};
