import type { FC } from 'react';
import ReactDOM from 'react-dom';
import { EnvironmentRoot, Platform } from 'tachyon-environment';
import { CoreUiSsrRoot } from 'tachyon-more-ui';
import { ClientBrowserAndOSExample } from './ClientBrowserAndOSExample';
import { ClientNetworkStatsExample } from './ClientNetworkStatsExample';
import { EnvironmentExample } from './EnvironmentExample';

const Example: FC = () => (
  <CoreUiSsrRoot appRootElementId="root">
    <EnvironmentRoot
      common={{
        appEnvironment: 'development',
        appVersion: '1.0',
        clientApp: 'tachyon-environment-example',
        language: window.navigator.language,
        platform: Platform.MobileWeb,
      }}
      networkStatusDebounceWait={3000}
    >
      <EnvironmentExample />
      <ClientBrowserAndOSExample />
      <ClientNetworkStatsExample />
    </EnvironmentRoot>
  </CoreUiSsrRoot>
);

ReactDOM.render(<Example />, document.getElementById('root'));
