import type { FC } from 'react';
import { useDynamicSettings } from 'tachyon-dynamic-settings';
import {
  CoreText,
  Table,
  TableBody,
  TableCell,
  TableHeader,
  TableHeading,
  TableRow,
  WordBreak,
} from 'twitch-core-ui';

export const DynamicSettingsTable: FC = () => {
  const settings = useDynamicSettings();

  return (
    <Table>
      <TableHeader>
        <TableHeading label="key" />
        <TableHeading label="value" />
      </TableHeader>
      <TableBody>
        {Object.entries(settings).map(([key, value]) => (
          <TableRow key={key}>
            <TableCell>{key}</TableCell>
            <TableCell>
              <CoreText wordBreak={WordBreak.BreakAll}>
                {JSON.stringify(value)}
              </CoreText>
            </TableCell>
          </TableRow>
        ))}
      </TableBody>
    </Table>
  );
};
