import type { ChangeEvent, FC } from 'react';
import { Select } from 'twitch-core-ui';

interface SettingsSelectProps<T extends string = string> {
  currentValue: T;
  // to avoid having to deal with Enum rectification
  onNewValue: (value: any) => void;
  values: T[];
}

export const SettingsSelect: FC<SettingsSelectProps> = ({
  currentValue,
  onNewValue,
  values,
}) => {
  function onChange(e: ChangeEvent<HTMLSelectElement>): void {
    onNewValue(e.currentTarget.value);
  }

  return (
    <Select onChange={onChange} value={currentValue}>
      {values.map((value) => (
        <option key={value} value={value}>
          {value}
        </option>
      ))}
    </Select>
  );
};
