import type { FC } from 'react';
import { useState } from 'react';
import ReactDOM from 'react-dom';
import { DynamicSettingsRoot } from 'tachyon-dynamic-settings';
import type { AppEnvironment } from 'tachyon-environment';
import { CoreUiSsrRoot } from 'tachyon-more-ui';
import {
  CoreText,
  FontSize,
  FormGroup,
  FormGroupOrientation,
  Layout,
  LoadingSpinner,
  ResponsiveWrapper,
  TextType,
} from 'twitch-core-ui';
import { DynamicSettingsTable } from './DynamicSettingsTable';
import { SettingsSelect } from './SettingsSelect';
import { useFetchedDynamicSettings } from './useFetchedDynamicSettings';

type AppGroup = 'tachyon';
const appGroups: AppGroup[] = ['tachyon'];

// Note that app should be constrained by appGroup, but isn't here for simplicity
type App = 'laserarray' | 'starshot' | 'tomorrow' | 'valence';
const apps: App[] = ['tomorrow', 'starshot', 'valence', 'laserarray'];

const App: FC = () => {
  const [appGroup, setAppGroup] = useState<AppGroup>('tachyon');
  const [app, setApp] = useState<App>('tomorrow');
  const [appEnvironment, setAppEnvironment] =
    useState<AppEnvironment>('production');
  // dynamic settings shouldn't be fetched client-side; only done as example
  const settings = useFetchedDynamicSettings({ app, appEnvironment, appGroup });

  return (
    <CoreUiSsrRoot appRootElementId="root">
      <ResponsiveWrapper centered>
        <CoreText fontSize={FontSize.Size2} type={TextType.H1}>
          Current Dynamic Settings
        </CoreText>
        <Layout padding={2}>
          <FormGroup
            label="App Group"
            orientation={FormGroupOrientation.Horizontal}
          >
            <SettingsSelect
              currentValue={appGroup}
              onNewValue={setAppGroup}
              values={appGroups}
            />
          </FormGroup>
          <FormGroup label="App" orientation={FormGroupOrientation.Horizontal}>
            <SettingsSelect
              currentValue={app}
              onNewValue={setApp}
              values={apps}
            />
          </FormGroup>
          <FormGroup
            label="Environment"
            orientation={FormGroupOrientation.Horizontal}
          >
            <SettingsSelect
              currentValue={appEnvironment}
              onNewValue={setAppEnvironment}
              values={['production', 'staging', 'development']}
            />
          </FormGroup>
          <CoreText type={TextType.Em}>
            Currently these are non-functional pending further Actuator config
            updates.
          </CoreText>
        </Layout>
        {settings ? (
          <DynamicSettingsRoot settings={settings}>
            <DynamicSettingsTable />
          </DynamicSettingsRoot>
        ) : (
          <LoadingSpinner />
        )}
      </ResponsiveWrapper>
    </CoreUiSsrRoot>
  );
};

ReactDOM.render(<App />, document.getElementById('root'));
