import { useEffect, useState } from 'react';
import type {
  DynamicSettings,
  DynamicSettingsURLGeneratorOpts,
} from 'tachyon-dynamic-settings';
import { fetchDynamicSettings } from 'tachyon-dynamic-settings';

export function useFetchedDynamicSettings({
  app,
  appEnvironment,
  appGroup,
}: DynamicSettingsURLGeneratorOpts): DynamicSettings<{}> | null {
  const [dynamicSettings, setDynamicSettings] =
    useState<DynamicSettings<{}> | null>(null);

  useEffect(() => {
    fetchDynamicSettings({
      app,
      appEnvironment,
      appGroup,
      processor: (settings) => settings,
    })().then(setDynamicSettings);
  }, [app, appEnvironment, appGroup]);

  return dynamicSettings;
}
