import type { ReportEvent } from 'tachyon-event-reporter';
import {
  createConsoleReportEvent,
  createMultiReportEvent,
  createSpadeReportEvent,
} from 'tachyon-event-reporter';
import type { TwitchEvent } from 'tachyon-type-library';

interface MySpecialEvent extends TwitchEvent {
  event: 'my_special_event';
  properties: {
    someField: string;
  };
}

interface MyOtherSpecialEvent extends TwitchEvent {
  event: 'my_other_special_event';
  properties: {
    someField: string;
  };
}

type SpecialEvent = MyOtherSpecialEvent | MySpecialEvent;

// fetchSpadeURI fetches the spade URI du jour
function createReportEvent(): ReportEvent<SpecialEvent> {
  // This configures _both_ reporting to the console and to spade.
  // **NOTE**: TypeScript is inferring the type parameter of the reporters from the signature of `buildReporter`, you should not use default.
  return createMultiReportEvent([
    createConsoleReportEvent(),
    // we hard-code the default spade url here, but you should instead fetch the current rotator url
    createSpadeReportEvent({
      batchWindowMs: 1000,
      spadeUrl: 'https://spade.twitch.tv/',
    }),
  ]);
}

function main(): void {
  const reportEvent = createReportEvent();
  reportEvent({
    event: 'my_special_event',
    properties: {
      someField: 'blah',
    },
  });
}

main();
