const { resolve } = require('path');
const { cwd } = require('process');
const webpack = require('webpack');
const nodeExternals = require('webpack-node-externals');
const { name: library } = require('./package.json');

const nodeExternalsOpts = {};

module.exports = {
  entry: './src/index',
  resolve: {
    extensions: ['.tsx', '.ts', '.js'],
  },
  externals: [
    nodeExternals(nodeExternalsOpts),
    nodeExternals({
      ...nodeExternalsOpts,
      modulesDir: resolve(cwd(), '..', '..', 'node_modules'),
    }),
  ],
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'babel-loader',
      },
    ],
  },
  output: {
    filename: 'index.js',
    path: resolve(cwd(), 'dist'),
    libraryTarget: 'commonjs2',
    library,
  },
};
