import type { FC } from 'react';
import { Fragment } from 'react';
import styled from 'styled-components';
import type { ProcessedInteractionEventData } from 'tachyon-event-tracker';
import { ScText } from './components';

interface LastEventDataProps {
  eventData: ProcessedInteractionEventData | null;
}

const ScEventDataLevel = styled.dl`
  font-style: normal;
`;

const ScEventDataKey = styled.dt`
  font-weight: bold;
`;

const ScEventDataValue = styled.dd`
  font-style: italic;
  margin-left: 3rem;
`;

export const LastEventData: FC<LastEventDataProps> = ({ eventData }) => {
  if (!eventData) {
    return <p>No events triggered yet. Click a button to make one happen.</p>;
  }

  return (
    <>
      <ScText>
        The following unique fields would be merged with standard spade fields
        for event reporting:
      </ScText>
      <ScEventDataLevel>
        <ScEventDataKey>event</ScEventDataKey>
        <ScEventDataValue>{eventData.event}</ScEventDataValue>
        <ScEventDataKey>properties</ScEventDataKey>
        <ScEventDataValue>
          <ScEventDataLevel>
            {Object.entries(eventData.properties).map(([key, value]) => {
              if (!value) {
                return null;
              }

              return (
                <Fragment key={key}>
                  <ScEventDataKey>{key}</ScEventDataKey>
                  <ScEventDataValue>{value}</ScEventDataValue>
                </Fragment>
              );
            })}
          </ScEventDataLevel>
        </ScEventDataValue>
      </ScEventDataLevel>
    </>
  );
};
