import type { FC } from 'react';
import {
  ExtendInteractionMedium,
  InteractionType,
  useInteractionTracking,
  useTrackedListItem,
} from 'tachyon-event-tracker';
import { Interactable, InteractableType } from 'twitch-core-ui';
import { ScExampleSection, ScText } from './components';

const CustomListItem: FC<{ position: number }> = ({ position }) => {
  const trackInteraction = useInteractionTracking();
  const { interactionContent } = useTrackedListItem(position);

  return (
    <Interactable
      onClick={() => {
        trackInteraction({
          interaction: InteractionType.Click,
          interactionContent,
        });
      }}
      variant={InteractableType.Alpha}
    >
      Click me to see my properties
    </Interactable>
  );
};

export const ListInteractionExample: FC = () => {
  /* eslint-disable react/no-unescaped-entities */
  return (
    <ExtendInteractionMedium value="list-comp">
      <ScExampleSection>
        <ScText as="h3">List component with useInteractionTracking hook</ScText>
        <ScText>
          There's an ExtendInteractionMedium component surrounding this with
          value "list-comp". Below is a list of Interactables that will get
          standardized interaction content from the useInteractionTracking hook.
          The list itself is surrounded in another ExtendInteractionMedium
          component with value "interactable-list".
        </ScText>
        <ExtendInteractionMedium value="interactable-list">
          {[0, 1, 2].map((position) => (
            <CustomListItem key={position} position={position} />
          ))}
        </ExtendInteractionMedium>
      </ScExampleSection>
    </ExtendInteractionMedium>
  );
  /* eslint-enable react/no-unescaped-entities */
};
