import type { TextCue } from 'pulsar';
import { useClosedCaptions } from 'pulsar';
import type { FC } from 'react';
import { useEffect, useState } from 'react';
import styled from 'styled-components';
import {
  AlignItems,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Layout,
  Position,
} from 'twitch-core-ui';

const SCCaptionContainer = styled(Layout)`
  bottom: 10%;
  left: 50%;
  top: auto;
  transform: translate(-50%, -50%);
  width: 50%;
`;

const SCCaptionText = styled(CoreText)`
  background-color: rgb(0, 0, 0);
  color: rgb(255, 255, 255);
  padding: 0 0.5rem;
`;

export const ClosedCaptions: FC = () => {
  const { subscribe } = useClosedCaptions();
  const [caption, setCaption] = useState<TextCue | null>(null);

  useEffect(() => {
    return subscribe(setCaption);
  }, [subscribe]);

  return (
    <SCCaptionContainer position={Position.Absolute}>
      <Layout
        alignItems={AlignItems.Center}
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
      >
        {caption && (
          <SCCaptionText fontSize={FontSize.Size4}>
            {caption.text}
          </SCCaptionText>
        )}
      </Layout>
    </SCCaptionContainer>
  );
};
