import { usePlaybackAd } from 'pulsar';
import type { FC } from 'react';
import { CoreText, TextType } from 'twitch-core-ui';

export const AdStatus: FC = () => {
  const ad = usePlaybackAd();

  return (
    <div>
      <CoreText type={TextType.H5}>{'Ad Status'}</CoreText>
      {ad ? (
        <>
          <CoreText>{`Ad ${ad.podPosition + 1} of ${ad.podCount}`}</CoreText>
          <CoreText>{`Remaining: ${ad.remainingTimeSeconds}`}</CoreText>
        </>
      ) : (
        <CoreText>{'No Ad Playing'}</CoreText>
      )}
    </div>
  );
};
