import { usePlaybackState, usePlayerController } from 'pulsar';
import type { FC } from 'react';
import { errorMessageFromCatch } from 'tachyon-utils';
import { ButtonIcon, SVGAsset } from 'twitch-core-ui';

export const PlayPauseButton: FC = () => {
  const controller = usePlayerController();
  const playbackState = usePlaybackState();

  async function clickHandler(): Promise<void> {
    if (!controller) {
      return;
    }

    if (playbackState === 'Playing') {
      controller.pause();
      return;
    }

    try {
      await controller.play();
    } catch (e) {
      window.alert(`Imperative play failed: ${errorMessageFromCatch(e)}`);
    }
  }

  return (
    <ButtonIcon
      aria-label={controller?.isPaused() ? 'play' : 'pause'}
      disabled={!controller}
      icon={
        playbackState === 'Playing' ? SVGAsset.MiniPlayerPause : SVGAsset.Play
      }
      onClick={clickHandler}
    />
  );
};
