import { formatVideoQualityName, usePlaybackQuality } from 'pulsar';
import type { FC } from 'react';
import {
  AlignItems,
  Button,
  ButtonType,
  Display,
  DropDownMenu,
  DropDownMenuItem,
  JustifyContent,
  Layout,
  Position,
  Tooltip,
  useDialogState,
} from 'twitch-core-ui';

export const QualitySelector: FC = () => {
  const { anchorProps, dialogProps } = useDialogState();

  const qualitySettings = usePlaybackQuality();
  if (!qualitySettings) {
    return null;
  }

  const { options, quality, setQuality } = qualitySettings;
  const activeName = formatVideoQualityName(quality);
  return (
    <Layout position={Position.Relative}>
      <Layout
        alignItems={AlignItems.Center}
        display={Display.Flex}
        justifyContent={JustifyContent.End}
      >
        <Tooltip label="Quality Settings">
          <Button {...anchorProps} aria-label="" variant={ButtonType.Secondary}>
            {activeName}
          </Button>
        </Tooltip>
      </Layout>
      <DropDownMenu {...dialogProps}>
        {options.map((q) => {
          const name = formatVideoQualityName(q);
          return (
            <DropDownMenuItem
              key={name}
              onClick={() => {
                setQuality(q);
              }}
              selected={name === activeName}
            >
              {name}
            </DropDownMenuItem>
          );
        })}
      </DropDownMenu>
    </Layout>
  );
};
