import { usePlaybackTime, usePlayerController } from 'pulsar';
import type { ChangeEvent, FC } from 'react';
import { formatVideoLength } from 'tachyon-utils';
import {
  Button,
  ButtonType,
  CoreText,
  Display,
  JustifyContent,
  Layout,
  Range,
} from 'twitch-core-ui';

export const Seekbar: FC = () => {
  const controller = usePlayerController();
  const playbackTime = usePlaybackTime();

  const changeHandler = (e: ChangeEvent<HTMLInputElement>) => {
    const newTime = e.currentTarget.valueAsNumber;
    if (newTime >= 0) {
      controller?.seekTo(newTime);
    }
  };

  function handleSkipToEnd() {
    controller?.seekTo(controller.getDuration());
  }

  return (
    <>
      <Layout display={Display.Flex} justifyContent={JustifyContent.Between}>
        <CoreText>{formatVideoLength(playbackTime)}</CoreText>
        <Button onClick={handleSkipToEnd} variant={ButtonType.Text}>
          Skip To End
        </Button>
      </Layout>
      <Range
        defaultValue={playbackTime.toString()}
        fill
        max={controller?.getDuration() ?? 100}
        min={0}
        onChange={changeHandler}
        step={1}
      />
    </>
  );
};
