import {
  useClosedCaptions,
  usePlaybackState,
  usePlayerController,
} from 'pulsar';
import type { FC } from 'react';
import {
  AlignItems,
  CheckBox,
  CoreText,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  TextType,
} from 'twitch-core-ui';
import { AdStatus } from './AdStatus';
import { PlayPauseButton } from './PlayPauseButton';
import { QualitySelector } from './QualitySelector';
import { Seekbar } from './Seekbar';
import { VolumeControl } from './VolumeControl';

type PlayerRefControllerProps = {
  displayVideoTime: boolean;
  onControlsToggle: () => void;
  onLowLatencyToggle: () => void;
};

export const CustomPlayerControls: FC<PlayerRefControllerProps> = ({
  displayVideoTime,
  onControlsToggle,
  onLowLatencyToggle,
}) => {
  const playbackState = usePlaybackState();
  const controller = usePlayerController();
  const { available, enabled, toggle } = useClosedCaptions();

  return (
    <Layout margin={0.5}>
      <Layout display={Display.Flex} justifyContent={JustifyContent.Between}>
        <div>
          {`Controller State: ${controller ? 'Available' : 'Unavailable'}`}
        </div>
        <div>{`Playback State: ${playbackState}`}</div>
        <Layout display={Display.Flex}>
          <CheckBox
            defaultChecked
            label="Native Controls"
            onChange={onControlsToggle}
          />
          <Layout padding={{ left: 1 }}>
            <CheckBox
              defaultChecked={enabled}
              disabled={!available}
              label="Captions"
              onChange={toggle}
            />
          </Layout>
          <Layout padding={{ left: 1 }}>
            <CheckBox
              defaultChecked
              label="Low Latency"
              onChange={onLowLatencyToggle}
            />
          </Layout>
        </Layout>
      </Layout>
      <Layout padding={{ y: 1 }}>
        <CoreText type={TextType.H4}>Imperative Controls</CoreText>
      </Layout>
      {displayVideoTime && <Seekbar />}
      <Layout
        display={Display.Flex}
        flexDirection={FlexDirection.Row}
        justifyContent={JustifyContent.Between}
      >
        <Layout
          alignItems={AlignItems.Center}
          display={Display.Flex}
          justifyContent={JustifyContent.Center}
        >
          <PlayPauseButton />
          <VolumeControl />
        </Layout>
        <QualitySelector />
      </Layout>
      <AdStatus />
    </Layout>
  );
};
