import { usePlaybackState } from 'pulsar';
import type { FC, ReactNode } from 'react';
import {
  AlignItems,
  Background,
  CoreText,
  Display,
  JustifyContent,
  Layout,
  LoadingSpinner,
  Position,
  SpinnerSize,
} from 'twitch-core-ui';

export const PlayerOverlay: FC = () => {
  const playbackState = usePlaybackState();

  let content: ReactNode;
  switch (playbackState) {
    case 'Buffering':
      content = (
        <LoadingSpinner delay={1000} fillContent size={SpinnerSize.Large} />
      );
      break;
    case 'Ended':
      content = (
        <Layout
          alignItems={AlignItems.Center}
          background={Background.Overlay}
          display={Display.Flex}
          fullHeight
          fullWidth
          justifyContent={JustifyContent.Center}
        >
          <CoreText>End of content!</CoreText>
        </Layout>
      );
      break;
  }

  if (!content) {
    return null;
  }

  return (
    <Layout
      attachBottom
      attachLeft
      attachRight
      attachTop
      position={Position.Absolute}
    >
      {content}
    </Layout>
  );
};
