import type { FC } from 'react';
import { createContext, useContext, useMemo } from 'react';
import type { MarkEvent } from '../TestSuite/useEventMarker';

type PulsarConsumerContext = {
  liveLowLatencyEnabled: boolean;
  markEvent: MarkEvent;
  showControls: boolean;
};

const pulsarConsumerContext = createContext<PulsarConsumerContext>({
  liveLowLatencyEnabled: false,
  markEvent: () => undefined,
  showControls: false,
});

export function usePlayerConsumer(): PulsarConsumerContext {
  return useContext(pulsarConsumerContext);
}

type PulsarConsumerRootProps = PulsarConsumerContext;

export const PlayerConsumerRoot: FC<PulsarConsumerRootProps> = ({
  children,
  liveLowLatencyEnabled,
  markEvent,
  showControls,
}) => {
  const ctx = useMemo<PulsarConsumerContext>(
    () => ({
      liveLowLatencyEnabled,
      markEvent,
      showControls,
    }),
    [liveLowLatencyEnabled, markEvent, showControls],
  );

  return <pulsarConsumerContext.Provider children={children} value={ctx} />;
};
