import type { FC } from 'react';
import { Button, Layout } from 'twitch-core-ui';
import type { EventData, EventMap } from './useEventMarker';

const EventRow: FC<{ data: EventData | null; event: string }> = ({
  data,
  event,
}) => (
  <tr>
    <td>{event}</td>
    <td>{data?.count ?? 0}</td>
    <td>{data?.firstMarkMS ?? 'N/A'}</td>
    <td>{data?.lastMarkMS ?? 'N/A'}</td>
  </tr>
);

export type EventTableProps = {
  eventMap: EventMap;
  onEventsCleared: () => void;
};

export const EventTable: FC<EventTableProps> = ({
  eventMap,
  onEventsCleared,
}) => {
  const eventRows = Object.entries(eventMap).map(([event, data]) => (
    <EventRow data={data} event={event} key={event} />
  ));

  return (
    <Layout>
      <Layout padding={{ bottom: 1 }}>
        <Button onClick={onEventsCleared}>Clear Events</Button>
      </Layout>
      <table>
        <thead>
          <tr>
            <th>Event</th>
            <th>Count</th>
            <th>First Time (MS)</th>
            <th>Last Time (MS)</th>
          </tr>
        </thead>
        <tbody>{eventRows}</tbody>
      </table>
    </Layout>
  );
};
