import type { PlayerAnalyticsEvent } from 'pulsar';
import { useState } from 'react';

export type EventData = {
  count: number;
  firstMarkMS: number;
  lastMarkMS: number;
};

export type EventMap = { [key: string]: EventData | null };

export type MarkEvent = (event: PlayerAnalyticsEvent) => void;

export function useEventMarker(appInitTimeMS: number): {
  clearEvents: () => void;
  eventMap: EventMap;
  markEvent: MarkEvent;
} {
  const [eventMap, setEventMap] = useState<EventMap>({});

  function markEvent(event: PlayerAnalyticsEvent): void {
    console.log('event', event);
    setEventMap((prevState) => {
      let data = prevState[event.name];
      if (!data) {
        data = {
          count: 1,
          firstMarkMS: Date.now() - appInitTimeMS,
          lastMarkMS: Date.now() - appInitTimeMS,
        };
      } else {
        data.count++;
        data.lastMarkMS = Date.now() - appInitTimeMS;
      }
      return {
        ...prevState,
        [event.name]: data,
      };
    });
  }

  return { clearEvents: () => setEventMap({}), eventMap, markEvent };
}
