import type { PulsarCoreProps } from 'pulsar';
import { PulsarCore } from 'pulsar';
import type { FC } from 'react';
import { useRef } from 'react';
import { uniqueIDGenerator } from 'tachyon-utils';
import { CLIENT_ID } from '../../../../../config';
import { usePlayerConsumer } from '../../PulsarConsumerRoot';

/**
 * Player-Core worker assets are moved into /public/player-core/ at build time.
 */
const PLAYER_CORE_ASSET_PATH = `${process.env.PUBLIC_URL}/player-core/`;

const PLAYER_CORE_ASSET_URLS: PulsarCoreProps['assetUrls'] = {
  asmWorker: `${PLAYER_CORE_ASSET_PATH}amazon-ivs-worker.min.js`,
  wasmBinary: `${PLAYER_CORE_ASSET_PATH}amazon-ivs-wasmworker.min.wasm`,
  wasmWorker: `${PLAYER_CORE_ASSET_PATH}amazon-ivs-wasmworker.min.js`,
};

type PulsarCoreBackendProps = Pick<
  PulsarCoreProps,
  'autoPlay' | 'loop' | 'params' | 'src' | 'startTime'
>;

export const PulsarCoreBackend: FC<PulsarCoreBackendProps> = (
  pulsarPlayerCoreProps,
) => {
  const { liveLowLatencyEnabled, showControls } = usePlayerConsumer();
  const { current: sessionId } = useRef(uniqueIDGenerator());
  const { current: deviceId } = useRef(uniqueIDGenerator());

  return (
    <PulsarCore
      assetUrls={PLAYER_CORE_ASSET_URLS}
      controls={showControls}
      environment={{
        benchmarkSessionID: sessionId,
        clientAPIID: CLIENT_ID,
        clientApp: 'pulsar-consumer-example',
        clientBuildID: '1234',
        deviceID: deviceId,
        platform: 'create-react-app',
      }}
      liveLowLatencyEnabled={liveLowLatencyEnabled}
      {...pulsarPlayerCoreProps}
    />
  );
};
