import { PulsarNative, browserSupportsHLS } from 'pulsar';
import type { FC } from 'react';
import type { PulsarBackendProps } from '../../../../types';
import { usePlayerConsumer } from '../../PulsarConsumerRoot';

export const PulsarNativeBackend: FC<PulsarBackendProps> = (props) => {
  if (!browserSupportsHLS()) {
    throw new Error('This browser does not support HLS, try Safari.');
  }

  const { showControls } = usePlayerConsumer();

  return <PulsarNative controls={showControls} {...props} />;
};
