import { useState } from 'react';
import type { ChangeEvent, FC, MouseEvent } from 'react';
import {
  AlignItems,
  Button,
  CoreText,
  Display,
  Input,
  InputType,
  Layout,
} from 'twitch-core-ui';

type ClipSetterProps = {
  defaultClipSlug: string;
  onContentChange: (slug: string) => void;
};

export const ClipSetter: FC<ClipSetterProps> = ({
  defaultClipSlug,
  onContentChange,
}) => {
  const [clipSlug, setClipSlug] = useState(defaultClipSlug);

  function inputChangeHandler(e: ChangeEvent<HTMLInputElement>): void {
    setClipSlug(e.target.value.toLowerCase());
  }

  function playClickHandler(event: MouseEvent<HTMLElement>): void {
    event.preventDefault();
    onContentChange(clipSlug);
  }

  return (
    <Layout alignItems={AlignItems.Center} display={Display.Flex}>
      <CoreText>Clip Slug</CoreText>
      <Layout padding={{ x: 1 }}>
        <Input
          onChange={inputChangeHandler}
          type={InputType.Text}
          value={clipSlug}
        />
      </Layout>
      <Button
        disabled={!clipSlug || clipSlug === defaultClipSlug}
        onClick={playClickHandler}
      >
        Play Clip
      </Button>
    </Layout>
  );
};
