import { useState } from 'react';
import type { ChangeEvent, FC } from 'react';
import {
  AlignItems,
  Button,
  ButtonType,
  CoreText,
  Display,
  Input,
  InputType,
  Layout,
} from 'twitch-core-ui';

type StreamSetterProps = {
  defaultStreamLogin: string;
  onStreamSet: (streamLogin: string) => void;
};

export const StreamSetter: FC<StreamSetterProps> = ({
  defaultStreamLogin,
  onStreamSet,
}) => {
  const [streamText, setStreamText] = useState(defaultStreamLogin);

  function inputChangeHandler(e: ChangeEvent<HTMLInputElement>): void {
    setStreamText(e.target.value.toLowerCase());
  }

  function setStreamShortcut(channel: string): void {
    setStreamText(channel);
    onStreamSet(channel);
  }

  return (
    <Layout alignItems={AlignItems.Center} display={Display.Flex}>
      <CoreText>Stream Login</CoreText>
      <Layout padding={{ left: 1 }}>
        <Input
          defaultValue={defaultStreamLogin}
          onChange={inputChangeHandler}
          type={InputType.Text}
        />
      </Layout>
      <Layout padding={{ left: 1 }}>
        <Button
          disabled={!streamText || defaultStreamLogin === streamText}
          onClick={() => setStreamShortcut(streamText)}
        >
          Load Stream
        </Button>
      </Layout>
      <Layout padding={{ left: 1 }}>
        <Button
          onClick={() => setStreamShortcut('TwitchMedia26')}
          variant={ButtonType.Text}
        >
          Play SureStream
        </Button>
      </Layout>
      <Layout padding={{ left: 1 }}>
        <Button
          onClick={() => setStreamShortcut('hgg_cheering_test')}
          variant={ButtonType.Text}
        >
          Play Sub-Only-Live
        </Button>
      </Layout>
      <Layout padding={{ left: 1 }}>
        <Button
          onClick={() => setStreamShortcut('chanlet_2592698654806')}
          variant={ButtonType.Text}
        >
          Play Sub-Only AAP
        </Button>
      </Layout>
      <Layout padding={{ left: 1 }}>
        <Button
          onClick={() => setStreamShortcut('hungry')}
          variant={ButtonType.Text}
        >
          Play Captioned Channel
        </Button>
      </Layout>
    </Layout>
  );
};
