// We use babel plugin macros here to work with CRA. Normally you would use
// `import { graphql } from 'react-relay';` with a proper babel config.
// @ts-expect-error: no type-defs available
import graphql from 'babel-plugin-relay/macro';
import type { FC } from 'react';
import { useFragment, useLazyLoadQuery } from 'react-relay/hooks';
import { CoreText, TextType } from 'twitch-core-ui';
import type {
  CompWithQuery_Query,
  CompWithQuery_QueryVariables,
} from './__generated__/CompWithQuery_Query.graphql';
import type { CompWithQuery_game$key } from './__generated__/CompWithQuery_game.graphql';

const gameFragment = graphql`
  fragment CompWithQuery_game on Game {
    name
  }
`;

type GameProps = {
  game: CompWithQuery_game$key;
};

const Game: FC<GameProps> = ({ game: gameRef }) => {
  const { name } = useFragment(gameFragment, gameRef);
  return <li key={name}>{name}</li>;
};

const compWithQueryQuery = graphql`
  query CompWithQuery_Query($gamesCount: Int!) {
    games(first: $gamesCount) {
      edges {
        cursor
        node {
          ...CompWithQuery_game
        }
      }
    }
  }
`;

export const CompWithQuery: FC = () => {
  const variables: CompWithQuery_QueryVariables = { gamesCount: 5 };
  const data = useLazyLoadQuery<CompWithQuery_Query>(
    compWithQueryQuery,
    variables,
  );
  return (
    <div>
      <CoreText type={TextType.H2}>
        Top {data?.games?.edges?.length || variables.gamesCount} Games
      </CoreText>
      <ul>
        {data?.games?.edges?.map(
          (edge, idx) => edge.node && <Game game={edge.node} key={idx} />,
        )}
      </ul>
    </div>
  );
};
