import type { FC } from 'react';
import { useRequestInfo } from 'tachyon-relay';
import { CoreText, TextType } from 'twitch-core-ui';

export const CompWithRequestInfo: FC = () => {
  const requestInfo = useRequestInfo();

  if (!requestInfo) {
    return null;
  }

  return (
    <CoreText type={TextType.H3}>
      Your IP address is {requestInfo.ipAddress}
    </CoreText>
  );
};
