import type { FC } from 'react';
import { Suspense } from 'react';
import ReactDOM from 'react-dom';
import { RelayEnvironmentProvider } from 'react-relay/hooks';
import { CoreUiSsrRoot } from 'tachyon-more-ui';
import {
  RequestInfoRoot,
  configureTachyonRelay,
  initEnvironment,
} from 'tachyon-relay';
import { useConst } from 'tachyon-utils';
import {
  Background,
  CoreText,
  Layout,
  LoadingSpinner,
  SpinnerSize,
  TextType,
} from 'twitch-core-ui';
import { CompWithQuery } from './CompWithQuery';
import { CompWithRequestInfo } from './CompWithRequestInfo';

// This is Tomorrow (Mobile Web's) Client ID, do not use it, get your own
configureTachyonRelay({ clientId: 'r8s4dac0uhzifbpu9sjdiwzctle17ff' });

const Example: FC = () => {
  const environment = useConst(initEnvironment);

  return (
    <RelayEnvironmentProvider environment={environment}>
      <CoreUiSsrRoot appRootElementId="root">
        <RequestInfoRoot>
          <Layout background={Background.Base} fullHeight fullWidth>
            <Layout margin={{ bottom: 5 }}>
              <CoreText type={TextType.H1}>Tachyon Relay Example</CoreText>
            </Layout>
            <Suspense
              fallback={<LoadingSpinner fillContent size={SpinnerSize.Large} />}
            >
              <CompWithQuery />
            </Suspense>
            <Layout margin={{ top: 5 }}>
              <CompWithRequestInfo />
            </Layout>
          </Layout>
        </RequestInfoRoot>
      </CoreUiSsrRoot>
    </RelayEnvironmentProvider>
  );
};

ReactDOM.render(<Example />, document.getElementById('root'));
