import type {
  DetailedReportReasonFragment,
  ReportReasonFragment,
  ReportWizardFragment,
  ReportableContentFragment,
  ReportableContentReasonFragment,
} from 'tachyon-report-wizard';

export const sampleDetailedReasons: DetailedReportReasonFragment[] = [
  {
    deadEndType: 'REPORTABLE',
    id: 'targetedabuse',
    title: 'Targeted Abuse',
  },
  {
    deadEndType: 'REPORTABLE',
    id: 'coordinatingharassment',
    title: 'Coordinating Harassment',
  },
  {
    deadEndType: 'REPORTABLE',
    id: 'pranks',
    title: 'Malicious Pranks',
  },
  {
    deadEndType: 'REPORTABLE',
    id: 'advocatingbullying',
    title: 'Advocating Bullying or Harassment toward others',
  },
  {
    deadEndType: 'REPORTABLE',
    id: 'mockingtrauma',
    title: 'Mocking Trauma',
  },
  {
    deadEndType: 'REPORTABLE',
    id: 'sexualadvances',
    title: 'Unwanted Sexual Advances',
  },
];

export const sampleNetzDGReasons: ReportReasonFragment[] = [
  {
    description: 'Language that is hateful',
    detailedReasons: [
      {
        deadEndType: 'REPORTABLE',
        id: 'slurs',
        title: 'Slurs or Symbols',
      },
      {
        deadEndType: 'REPORTABLE',
        id: 'encouraginghateful',
        title: 'Encouraging Hateful Behaviour',
      },
      {
        deadEndType: 'REPORTABLE',
        id: 'threateningviolence',
        title: 'Threatening Violence',
      },
    ],
    id: 'hatespeech',
    isApplicableToCountryRegulations: true,
    text: 'Hate Speech',
  },
  {
    description: '',
    detailedReasons: [],
    id: 'terrorism',
    isApplicableToCountryRegulations: false,
    text: 'Terrorism',
  },
  {
    description: '',
    detailedReasons: sampleDetailedReasons,
    id: 'bullying',
    isApplicableToCountryRegulations: true,
    text: 'Bullying or Harassment',
  },
  {
    description: '',
    detailedReasons: [],
    id: 'violence',
    isApplicableToCountryRegulations: false,
    text: 'Violence or Gore',
  },
  {
    description: '',
    detailedReasons: [],
    id: 'nudity',
    isApplicableToCountryRegulations: false,
    text: 'Nudity or Sexually Explicit',
  },
  {
    description: '',
    detailedReasons: [
      {
        deadEndType: 'REPORTABLE',
        id: 'threateningselfharm',
        title: 'Threatening Self Harm',
      },
      {
        deadEndType: 'REPORTABLE',
        id: 'promotingselfharm',
        title: 'Actively Promoting self harm for others',
      },
    ],
    id: 'selfharm',
    isApplicableToCountryRegulations: false,
    text: 'Self Harm',
  },
  {
    description: '',
    detailedReasons: [
      {
        deadEndType: 'REPORTABLE',
        id: 'bot',
        title: 'Bot',
      },
      {
        deadEndType: 'REPORTABLE',
        id: 'scam',
        title: 'Scam',
      },
      {
        deadEndType: 'REPORTABLE',
        id: 'spam',
        title: 'Spam',
      },
    ],
    id: 'spam',
    isApplicableToCountryRegulations: false,
    text: 'Spam, Scams or Bots',
  },
  {
    description: '',
    detailedReasons: [
      {
        deadEndType: 'LINK_DMCA_GUIDELINES',
        id: 'ipviolation',
        title: 'IP Violation',
      },
    ],
    id: 'impersonation',
    isApplicableToCountryRegulations: false,
    text: 'Impersonation',
  },
  {
    description: '',
    detailedReasons: [],
    id: 'usernameviolation',
    isApplicableToCountryRegulations: false,
    text: 'Username Violation',
  },
  {
    description: '',
    detailedReasons: [],
    id: 'banevasion',
    isApplicableToCountryRegulations: false,
    text: 'Ban Evasion',
  },
  {
    description: '',
    detailedReasons: [],
    id: 'cheating',
    isApplicableToCountryRegulations: false,
    text: 'Cheating',
  },
];

const applicableReasons = (
  contentPrefix: string,
): ReportableContentReasonFragment[] => [
  {
    id: `${contentPrefix}:hatespeech`,
    reportReason: { id: 'hatespeech' },
    visibility: 'MAIN',
  },
  {
    id: `${contentPrefix}:terrorism`,
    reportReason: { id: 'terrorism' },
    visibility: 'MAIN',
  },
  {
    id: `${contentPrefix}:bullying`,
    reportReason: { id: 'bullying' },
    visibility: 'MAIN',
  },
  {
    id: `${contentPrefix}:nudity`,
    reportReason: { id: 'nudity' },
    visibility: 'MAIN',
  },
  {
    id: `${contentPrefix}:selfharm`,
    reportReason: { id: 'selfharm' },
    visibility: 'MAIN',
  },
  {
    id: `${contentPrefix}:spam`,
    reportReason: { id: 'spam' },
    visibility: 'MAIN',
  },
  {
    id: `${contentPrefix}:offplatform`,
    reportReason: { id: 'offplatform' },
    visibility: 'MAIN',
  },
  {
    id: `${contentPrefix}:banevasion`,
    reportReason: { id: 'banevasion' },
    visibility: 'SEARCH',
  },
  {
    id: `${contentPrefix}:pranks`,
    reportReason: { id: 'pranks' },
    visibility: 'SEARCH',
  },
  {
    id: `${contentPrefix}:cheating`,
    reportReason: { id: 'cheating' },
    visibility: 'SEARCH',
  },
  {
    id: `${contentPrefix}:impersonation`,
    reportReason: { id: 'impersonation' },
    visibility: 'SEARCH',
  },
];

export const sampleReportableContent: ReportableContentFragment[] = [
  {
    applicableReasons: applicableReasons('vod-report-id'),
    deadEndType: 'REPORT_FROM_VOD',
    id: 'vod-report-id',
    type: 'VOD_REPORT',
  },
  {
    applicableReasons: applicableReasons('clip-report-id'),
    deadEndType: 'REPORT_FROM_CLIP',
    id: 'clip-report-id',
    type: 'CLIP_REPORT',
  },
  {
    applicableReasons: applicableReasons('livestream-report-id'),
    deadEndType: 'REPORTABLE',
    id: 'livestream-report-id',
    type: 'LIVESTREAM_REPORT',
  },
  {
    applicableReasons: applicableReasons('username-report'),
    deadEndType: 'REPORTABLE',
    id: 'username-report-id',
    type: 'USERNAME_REPORT',
  },
  {
    applicableReasons: applicableReasons('emote-report-id'),
    deadEndType: 'REPORTABLE',
    id: 'emote-report-id',
    type: 'EMOTE_REPORT',
  },
  {
    applicableReasons: applicableReasons('chat-report-id'),
    deadEndType: 'REPORTABLE',
    id: 'chat-report-id',
    type: 'CHAT_REPORT',
  },
  {
    applicableReasons: applicableReasons('whisper-report-id'),
    deadEndType: 'REPORTABLE',
    id: 'whisper-report-id',
    type: 'WHISPER_REPORT',
  },
  {
    applicableReasons: applicableReasons('off-platform-report-id'),
    deadEndType: 'LINK_OFF_PLATFORM_GUIDELINES',
    id: 'off-platform-report-id',
    type: 'OFF_PLATFORM_REPORT',
  },
];

export const sampleReportWizardNetzDGData: ReportWizardFragment = {
  reasons: {
    countryCode: 'DE',
    disclosureText:
      'Mock Reports under these categories will be evaulated for Netzwerkdurchsetzungsgesetz',
    id: 'reasons-data-id',
    toSAndCountryReasons: sampleNetzDGReasons,
  },
  reportableContent: sampleReportableContent,
};

export const sampleReportWizardTOSData: ReportWizardFragment = {
  reasons: {
    countryCode: null,
    disclosureText: null,
    id: 'reasons-netzdg-data-id',
    toSAndCountryReasons: [...sampleNetzDGReasons].map((reason) => {
      const newReason = { ...reason };
      newReason.isApplicableToCountryRegulations = false;
      return newReason;
    }),
  },
  reportableContent: sampleReportableContent,
};
