import type { FC } from 'react';
import { useContext } from 'react';
import {
  Confirmation,
  Content,
  DeadEnd,
  Description,
  DetailedReason,
  Form,
  NetzDG,
  Reason,
  ReportWizardStep,
  reportWizardContext,
} from 'tachyon-report-wizard';

export const WizardExample: FC = () => {
  const { currentStep, reportSubmissionSuccess } =
    useContext(reportWizardContext);
  if (reportSubmissionSuccess) {
    return <Confirmation />;
  }
  return (
    <Form>
      {currentStep === ReportWizardStep.Content && <Content />}
      {currentStep === ReportWizardStep.DeadEnd && <DeadEnd />}
      {currentStep === ReportWizardStep.DetailedReason && <DetailedReason />}
      {currentStep === ReportWizardStep.Reason && <Reason />}
      {currentStep === ReportWizardStep.Description && <Description />}
      {currentStep === ReportWizardStep.NetzDG && <NetzDG />}
    </Form>
  );
};
