import type { FC } from 'react';
import styled from 'styled-components';
import { GridNav } from 'tachyon-tv-nav';
import { useConst } from 'tachyon-utils';
import {
  CoreText,
  FontSize,
  Layout,
  Tower,
  TowerChildWidth,
} from 'twitch-core-ui';
import { FocusableCard } from '../common';

/**
 * Ensure this and card-width below always result in a stable number of cards per row to avoid breaking navigation
 */
const CARDS_PER_ROW = 5;

const ScGridCardContainer = styled.div`
  width: 18vw;
`;

export const GridPage: FC<{
  focusIndex: number;
  handleWheel: boolean;
}> = ({ focusIndex, handleWheel }) => {
  const cards = useConst(() =>
    Array.from({ length: 30 }).map((_, index) => (
      <ScGridCardContainer key={index}>
        <FocusableCard focusIndex={index} />
      </ScGridCardContainer>
    )),
  );

  return (
    <Layout fullWidth padding={{ x: 2 }}>
      <CoreText fontSize={FontSize.Size2}>Grid</CoreText>
      <GridNav
        elementCount={30}
        elementsPerRow={CARDS_PER_ROW}
        focusIndex={focusIndex}
        handleWheel={handleWheel}
      >
        <Tower childWidth={TowerChildWidth.Large}>{cards}</Tower>
      </GridNav>
    </Layout>
  );
};
