import type { FC } from 'react';
import { useState } from 'react';
import styled from 'styled-components';
import { VerticalNav } from 'tachyon-tv-nav';
import { useStorage } from 'tachyon-utils';
import {
  AlignItems,
  Button,
  ButtonType,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  FormGroup,
  Input,
  InputType,
  Layout,
} from 'twitch-core-ui';
import { SimpleShelf, VirtualizedShelf } from '../common';

const ScFormContainer = styled(Layout)`
  width: 250px;
`;

const DEFAULT_SHELF_PAGE_SIZE = 5;

type ShelvesPageProps = {
  focusIndex: number;
  handleWheel: boolean;
};

export const ShelvesPage: FC<ShelvesPageProps> = ({
  focusIndex,
  handleWheel,
}) => {
  const [virtualizedShelfPageSize, setVirtualizedShelfPageSize] = useStorage(
    'handlePage',
    DEFAULT_SHELF_PAGE_SIZE,
  );
  const [shelfCount, setShelfCount] = useState(3);

  const simpleShelves = Array.from({ length: shelfCount }).map((_, i) => (
    <SimpleShelf focusIndex={i} key={i} />
  ));

  return (
    <Layout fullWidth>
      <ScFormContainer padding={{ x: 1, y: 1 }}>
        <FormGroup label="Page Size" labelOptional="Optional">
          <Input
            defaultValue={virtualizedShelfPageSize.toString()}
            onChange={({ currentTarget }) => {
              if (currentTarget.value) {
                setVirtualizedShelfPageSize(parseInt(currentTarget.value, 10));
              }
            }}
            type={InputType.Number}
          />
        </FormGroup>
      </ScFormContainer>
      <VerticalNav
        elementCount={shelfCount + 1}
        focusIndex={focusIndex}
        handleWheel={handleWheel}
      >
        <Layout
          alignItems={AlignItems.Center}
          display={Display.Flex}
          flexDirection={FlexDirection.Row}
          padding={{ bottom: 2, top: 4 }}
        >
          <CoreText fontSize={FontSize.Size2}>Simple Shelves</CoreText>
          <Layout padding={{ left: 1 }}>
            <Button
              onClick={() => setShelfCount((c) => c + 1)}
              variant={ButtonType.Secondary}
            >
              Add
            </Button>
          </Layout>
          <Layout padding={{ left: 1 }}>
            <Button
              disabled={shelfCount === 0}
              onClick={() => setShelfCount((c) => c - 1)}
              variant={ButtonType.Secondary}
            >
              Remove
            </Button>
          </Layout>
        </Layout>
        {simpleShelves}
        <Layout padding={{ bottom: 2, top: 4 }}>
          <CoreText fontSize={FontSize.Size2}>Virtualized Shelf</CoreText>
        </Layout>
        <VirtualizedShelf
          count={25}
          focusIndex={shelfCount}
          pageSize={virtualizedShelfPageSize}
        />
      </VerticalNav>
    </Layout>
  );
};
