import type { FC } from 'react';
import { refFocusHandler, useFocus } from 'tachyon-tv-nav';
import type { ButtonProps } from 'twitch-core-ui';
import { Button, ButtonType } from 'twitch-core-ui';

type FocusableButtonProps = Omit<ButtonProps, 'refHandler' | 'type'> & {
  focusIndex: number;
};

export const FocusableButton: FC<FocusableButtonProps> = ({
  focusIndex,
  ...buttonProps
}) => {
  const { focused } = useFocus(focusIndex);
  const type = focused ? ButtonType.Primary : ButtonType.Text;

  return (
    <Button
      refHandler={refFocusHandler(focused)}
      variant={type}
      {...buttonProps}
    />
  );
};
