import type { FC } from 'react';
import { useRef } from 'react';
import styled from 'styled-components';
import { refFocusHandler } from 'tachyon-tv-nav';
import {
  AlignItems,
  Background,
  Color,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  JustifyContent,
  Layout,
  WordBreak,
} from 'twitch-core-ui';

type CardBaseProps = {
  className?: string | undefined;
  focus: boolean;
  focusId: string;
  focusIndex: number;
};

const ScCardContainer = styled(Layout)`
  height: 9rem;
`;

export const Card: FC<CardBaseProps> = ({
  className,
  focus,
  focusId,
  focusIndex,
}) => {
  const renderCount = useRef(0);
  renderCount.current++;

  return (
    <ScCardContainer
      alignItems={AlignItems.Center}
      background={focus ? Background.AccentAlt2 : Background.Alt2}
      border
      // TODO CORE-UI-TYPES: Update core-ui types to accept undefined
      // https://jira.xarth.tv/browse/EMP-4748
      className={className as string}
      color={focus ? Color.Overlay : Color.Base}
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      justifyContent={JustifyContent.Center}
      margin={{ y: 1 }}
      ref={refFocusHandler(focus)}
    >
      <CoreText fontSize={FontSize.Size4}>{`Card: ${focusIndex}`}</CoreText>
      <CoreText fontSize={FontSize.Size5} wordBreak={WordBreak.BreakWord}>
        {JSON.stringify({
          focusId,
          renderCount: renderCount.current,
        })}
      </CoreText>
    </ScCardContainer>
  );
};
